﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;
    using Hims.Shared.UserModels.Laboratory;
    using Hims.Api.Models;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The patients controller.
    /// </summary>
    [Route("api/laboratory-dashboard")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class LaboratoryDashboardController : BaseController
    {
        /// <summary>
        /// The laboratory dashboard controller.
        /// </summary>
        private readonly ILaboratoryDashboardService laboratoryDashboardService;

        /// <inheritdoc />
        public LaboratoryDashboardController(ILaboratoryDashboardService laboratoryDashboardService) => this.laboratoryDashboardService = laboratoryDashboardService;


        /// <summary>
        /// The fetch labs details dashboardasync.
        /// </summary>
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpGet]
        [AllowAnonymous]
        [Route("fetch-lab-details-dashboard")]
        public async Task<ActionResult> FetchLabs()
        {
            var response = await this.laboratoryDashboardService.FetchLabs();
            return this.Success(response);
        }

        /// <summary>
        /// The fetch labs details async.
        /// </summary>
        /// <param name="model"></param>
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpGet]
        [AllowAnonymous]
        [Route("fetch-lab-details-dashboard-revenue")]
        public async Task<ActionResult> FetchLabRevenueGraphReport(LabsDashboardModel model, [FromHeader] LocationHeader header)
        {
            model.LocationId = Convert.ToInt32(header.LocationId);
            var response = await this.laboratoryDashboardService.FetchLabRevenueGraphReport(model);
            return this.Success(response);
        }
    }
}
